/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.plus.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.jndi.NamingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction
extends NamingEntry {
    private static final Logger LOG = LoggerFactory.getLogger(Transaction.class);
    public static final String USER_TRANSACTION = "UserTransaction";

    public static void bindTransactionToENC(String scope) throws NamingException {
        NamingEntry txEntry = NamingEntryUtil.lookupNamingEntry((Object)scope, (String)USER_TRANSACTION);
        if (!(txEntry instanceof Transaction)) {
            throw new NameNotFoundException("UserTransaction not found");
        }
        ((Transaction)txEntry).bindToComp();
    }

    public Transaction(String scope, UserTransaction userTransaction) throws NamingException {
        super((Object)scope, USER_TRANSACTION, (Object)userTransaction);
    }

    public void bindToENC(String localName) throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp/env");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Binding java:comp/env{} to {}", (Object)this.getJndiName(), (Object)this._objectNameString);
        }
        NamingUtil.bind((Context)env, (String)localName, (Object)new LinkRef(this._objectNameString));
    }

    private void bindToComp() throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Binding java:comp/{} to {}", (Object)this.getJndiName(), (Object)this._objectNameString);
        }
        NamingUtil.bind((Context)env, (String)this.getJndiName(), (Object)new LinkRef(this._objectNameString));
    }

    public void unbindENC() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unbinding java:comp/{}", (Object)this.getJndiName());
            }
            env.unbind(this.getJndiName());
        }
        catch (NamingException e) {
            LOG.warn("Unable to unbind java:comp/{}", (Object)this.getJndiName(), (Object)e);
        }
    }
}

