/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;

final class WidthBucket<T extends Number>
extends AbstractField<T> {
    private static final long serialVersionUID = -4866100604361006859L;
    private final Field<T> field;
    private final Field<T> low;
    private final Field<T> high;
    private final Field<Integer> buckets;

    WidthBucket(Field<T> field, Field<T> low, Field<T> high, Field<Integer> buckets) {
        super(DSL.name("width_bucket"), field.getDataType());
        this.field = field;
        this.low = low;
        this.high = high;
        this.buckets = buckets;
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                ctx.visit(DSL.field("{width_bucket}({0}, {1}, {2}, {3})", this.getType(), this.field, this.low, this.high, this.buckets));
                break;
            }
            default: {
                ctx.visit(DSL.when(this.field.lt(this.low), DSL.zero()).when(this.field.ge(this.high), this.buckets.add(DSL.one())).otherwise(DSL.floor(this.field.sub(this.low).mul(this.buckets).div(this.high.sub(this.low))).add(DSL.one())));
            }
        }
    }
}

