/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import com.plantuml.ubrex.UMatcher;
import com.plantuml.ubrex.UnicodeBracketedExpression;
import java.util.List;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.creole.command.AddStyle;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontStyle;

public class CommandCreoleStyle
implements Command {
    private final FontStyle style;
    private final boolean tryExtendedColor;
    private final UnicodeBracketedExpression ubrex;

    @Override
    public String startingChars() {
        return "</*_~-";
    }

    public static Command createCreole(FontStyle style) {
        String ubrexString = style.getUbrexCreoleSyntax() + "\u3036$V=\u3004+\u3034.->\u3018" + style.getUbrexCreoleSyntax() + "\u3019";
        return new CommandCreoleStyle(ubrexString, style, false);
    }

    public static Command createLegacy(FontStyle style) {
        String ubrexString = style.getUbrexActivationPattern() + "\u3036$V=\u3004>\u3018" + style.getUbrexDeactivationPattern() + "\u3019";
        return new CommandCreoleStyle(ubrexString, style, style.canHaveExtendedColor());
    }

    public static Command createLegacyEol(FontStyle style) {
        String ubrexString = style.getUbrexActivationPattern() + "\u3036$V=\u3007+\u3034.";
        return new CommandCreoleStyle(ubrexString, style, style.canHaveExtendedColor());
    }

    private CommandCreoleStyle(String ubrexString, FontStyle style, boolean tryExtendedColor) {
        this.ubrex = UnicodeBracketedExpression.build(ubrexString);
        this.style = style;
        this.tryExtendedColor = tryExtendedColor;
    }

    private HColor getExtendedColor(UMatcher matcher) {
        List<String> extendedColor;
        if (this.tryExtendedColor && (extendedColor = matcher.getCapture("XC")).size() > 0) {
            return HColorSet.instance().getColorOrWhite(extendedColor.get(0));
        }
        return null;
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        UMatcher matcher = this.ubrex.match(line);
        List<String> value = matcher.getCapture("V");
        String accepted = matcher.getAcceptedMatch();
        if (value.size() == 0) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = new AddStyle(this.style, this.getExtendedColor(matcher)).apply(fc1);
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(value.get(0));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(accepted.length());
    }

    @Override
    public int matchingSize(String line) {
        UMatcher matcher = this.ubrex.match(line);
        List<String> value = matcher.getCapture("V");
        if (value.size() == 0) {
            return 0;
        }
        return value.get(0).length();
    }
}

