/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.module;

import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.io.InputStream;

public final class PythonFrozenModule {
    private final TruffleString originalName;
    private final byte[] code;
    private final boolean isPackage;

    private static byte[] getByteCode(String symbol) {
        try {
            InputStream resourceAsStream = PythonFrozenModule.class.getResourceAsStream("Frozen" + symbol + "." + PythonFrozenModule.getSuffix());
            if (resourceAsStream != null) {
                return resourceAsStream.readAllBytes();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String getSuffix() {
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            return "bin_dsl";
        }
        return "bin";
    }

    public PythonFrozenModule(String symbol, String originalName, boolean isPackage) {
        this(PythonUtils.toTruffleStringUncached(originalName), PythonFrozenModule.getByteCode(symbol), isPackage);
    }

    private PythonFrozenModule(TruffleString originalName, byte[] code, boolean isPackage) {
        this.originalName = originalName;
        this.code = code;
        this.isPackage = isPackage;
    }

    public PythonFrozenModule asPackage(boolean flag) {
        if (flag == this.isPackage) {
            return this;
        }
        TruffleString origName = this.originalName;
        if (this.isPackage) {
            origName = StringLiterals.T_LANGLE.concatUncached((AbstractTruffleString)this.originalName, PythonUtils.TS_ENCODING, false);
        }
        return new PythonFrozenModule(origName, this.code, flag);
    }

    public TruffleString getOriginalName() {
        return this.originalName;
    }

    public byte[] getCode() {
        return this.code;
    }

    public boolean isPackage() {
        return this.isPackage;
    }

    public int getSize() {
        return this.code != null ? this.code.length : 0;
    }
}

