/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.typing;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.TypingModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.types.GenericTypeNodes;
import com.oracle.graal.python.builtins.objects.typing.PTypeAliasType;
import com.oracle.graal.python.builtins.objects.typing.TypeAliasTypeBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.typing.TypeAliasTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.typing.TypeAliasTypeBuiltinsSlotsGen;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTypeAliasType})
public final class TypeAliasTypeBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TypeAliasTypeBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TypeAliasTypeBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        @Specialization(guards={"self.typeParams != null"})
        static Object doGenericAlias(PTypeAliasType self, Object args, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, self, args);
        }

        @Specialization(guards={"self.typeParams == null"})
        static Object doError(PTypeAliasType self, Object args, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ONLY_GENERIC_TYPE_ALIASES_ARE_SUBSCRIPTABLE);
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization
        static Object union(Object self, Object other, @Cached GenericTypeNodes.UnionTypeOrNode unionTypeOrNode) {
            return unionTypeOrNode.execute(self, other);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PTypeAliasType self) {
            return self.name;
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(PTypeAliasType self) {
            return self.name;
        }
    }

    @Builtin(name="__parameters__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetParametersNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.typeParams != null"})
        static PTuple doTypeParams(VirtualFrame frame, PTypeAliasType self, @Bind Node inliningTarget, @Cached TypingModuleBuiltins.UnpackTypeVarTuplesNode unpackTypeVarTuplesNode) {
            return unpackTypeVarTuplesNode.execute(frame, inliningTarget, self.typeParams);
        }

        @Specialization(guards={"self.typeParams == null"})
        static PTuple doEmpty(PTypeAliasType self, @Bind PythonLanguage language) {
            return PFactory.createEmptyTuple(language);
        }
    }

    @Builtin(name="__module__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetModuleNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.module != null"})
        static Object doModule(PTypeAliasType self) {
            return self.module;
        }

        @Specialization(guards={"self.module == null", "self.computeValue != null"})
        static Object doComputed(VirtualFrame frame, PTypeAliasType self, @Bind Node inliningTarget, @Cached PyObjectGetItem getItemNode) {
            PFunction fun;
            Object object = self.computeValue;
            if (object instanceof PFunction && (fun = (PFunction)object).getGlobals() != null) {
                return getItemNode.execute((Frame)frame, inliningTarget, fun.getGlobals(), SpecialAttributeNames.T___NAME__);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"self.module == null", "self.computeValue == null"})
        static Object doNone(PTypeAliasType self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="__value__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetValueNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.value != null"})
        static Object doEvaluated(PTypeAliasType self) {
            return self.value;
        }

        @Specialization(guards={"self.value == null"})
        static Object doEvaluate(VirtualFrame frame, PTypeAliasType self, @Cached CallNode callNode) {
            assert (self.computeValue != null);
            self.value = callNode.execute((Frame)frame, self.computeValue, new Object[0]);
            self.computeValue = null;
            return self.value;
        }
    }

    @Builtin(name="__type_params__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetTypeParamsNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.typeParams != null"})
        static PTuple doTypeParams(PTypeAliasType self) {
            return self.typeParams;
        }

        @Specialization(guards={"self.typeParams == null"})
        static PTuple doEmpty(PTypeAliasType self, @Bind PythonLanguage language) {
            return PFactory.createEmptyTuple(language);
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString doName(PTypeAliasType self) {
            return self.name;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="TypeAliasType", minNumOfPositionalArgs=3, parameterNames={"$cls", "name", "value"}, keywordOnlyNames={"type_params"}, needsFrame=true, alwaysNeedsCallerFrame=true)
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class TypeAliasTypeNode
    extends PythonClinicBuiltinNode {
        TypeAliasTypeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TypeAliasTypeBuiltinsClinicProviders.TypeAliasTypeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PTypeAliasType newTypeAliasType(VirtualFrame frame, Object cls, TruffleString name, Object value, Object typeParams, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached CheckTypeParamsNode checkNode, @Cached TypingModuleBuiltins.CallerNode callerNode, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            PTuple typeParamsTuple = checkNode.execute(inliningTarget, typeParams);
            Object module = callerNode.execute(frame, inliningTarget);
            return PFactory.createTypeAliasType(language, cls, getInstanceShape.execute(cls), name, typeParamsTuple, null, value, module);
        }

        @GenerateInline
        @GenerateCached(value=false)
        @ImportStatic(value={PGuards.class})
        static abstract class CheckTypeParamsNode
        extends Node {
            CheckTypeParamsNode() {
            }

            abstract PTuple execute(Node var1, Object var2);

            @Specialization(guards={"isNoValue(o)"})
            static PTuple doDefault(Object o) {
                return null;
            }

            @Specialization
            static PTuple doTuple(PTuple o) {
                return o.getSequenceStorage().length() == 0 ? null : o;
            }

            @Fallback
            static PTuple doError(Object o, @Bind Node inliningTarget) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.TYPE_PARAMS_MUST_BE_A_TUPLE);
            }
        }
    }
}

