/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.StateSignatures;
import oracle.jdbc.driver.TemplateOverflow;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
class DatabaseSessionState
implements oracle.jdbc.internal.DatabaseSessionState {
    StateSignatures stateSignatures = null;
    long templateId = 0L;
    byte[] fullOverflow = null;
    List<byte[]> deltaOverflows = new ArrayList<byte[]>();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    DatabaseSessionState() {
    }

    @Override
    public oracle.jdbc.internal.StateSignatures getStateSignatures() {
        return this.stateSignatures;
    }

    @Override
    public long getId() {
        return this.templateId;
    }

    @Override
    public byte[] getCheckpoint() {
        return this.fullOverflow;
    }

    @Override
    public List<byte[]> getUpdates() {
        return this.deltaOverflows;
    }

    DatabaseSessionState copy() {
        DatabaseSessionState c2 = new DatabaseSessionState();
        c2.stateSignatures = this.stateSignatures.copy();
        c2.templateId = this.templateId;
        if (this.fullOverflow != null && this.fullOverflow.length > 0) {
            c2.fullOverflow = new byte[this.fullOverflow.length];
            System.arraycopy(this.fullOverflow, 0, c2.fullOverflow, 0, this.fullOverflow.length);
        }
        c2.deltaOverflows = new ArrayList<byte[]>();
        for (byte[] deltaOverflow : this.deltaOverflows) {
            if (deltaOverflow == null || deltaOverflow.length <= 0) continue;
            byte[] deltaCopy = new byte[deltaOverflow.length];
            System.arraycopy(deltaOverflow, 0, deltaCopy, 0, deltaOverflow.length);
            c2.deltaOverflows.add(deltaCopy);
        }
        return c2;
    }

    /*
     * WARNING - void declaration
     */
    final void update(StateSignatures stateSignatures, TemplateOverflow templateOverflow) {
        void templateOverflow2;
        void stateSignatures2;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        this.stateSignatures = stateSignatures2;
        this.stateSignatures.signatureFlags &= 0xFFFFFFFFFFFFFFBFL;
        if (templateOverflow2 != null) {
            this.templateId = templateOverflow2.getTemplateId();
            byte[] overflow = templateOverflow2.getOverflow();
            boolean full = templateOverflow2.isOverflowComplete();
            if (full && overflow != null) {
                this.fullOverflow = overflow;
                if (bl) {
                    OracleLog.log($$$loggerRef$$$5, Level.FINE, this.getClass(), $$$methodRef$$$5, "Full state");
                }
            } else if (!full && overflow != null) {
                if (this.fullOverflow == null) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$5, Level.WARNING, this.getClass(), $$$methodRef$$$5, "Server sent delta-overflow without first sending full-overflow");
                    }
                } else {
                    this.deltaOverflows.add(overflow);
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$5, Level.FINE, this.getClass(), $$$methodRef$$$5, "Delta state");
                    }
                }
            } else if (full && overflow == null) {
                this.fullOverflow = null;
                this.deltaOverflows = new ArrayList<byte[]>();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$5, Level.FINE, this.getClass(), $$$methodRef$$$5, "Clear state");
                }
            }
        }
    }

    @DisableTrace
    public String toString() {
        return "DatabaseSessionState[StateSignatures=" + this.stateSignatures + ", TemplateID=" + Long.toHexString(this.getId()) + ", Full-overflow: " + (this.fullOverflow == null ? 0 : 1) + ", Delta-overflow: " + this.deltaOverflows.size() + "]";
    }

    static {
        try {
            $$$methodRef$$$6 = DatabaseSessionState.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = DatabaseSessionState.class.getDeclaredMethod("update", StateSignatures.class, TemplateOverflow.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = DatabaseSessionState.class.getDeclaredMethod("copy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = DatabaseSessionState.class.getDeclaredMethod("getUpdates", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = DatabaseSessionState.class.getDeclaredMethod("getCheckpoint", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = DatabaseSessionState.class.getDeclaredMethod("getId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = DatabaseSessionState.class.getDeclaredMethod("getStateSignatures", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

