/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.mmap;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.mmap.MMapBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.mmap.MMapBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.mmap.MMapBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.mmap.PMMap;
import com.oracle.graal.python.builtins.objects.range.RangeNodes;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotMpAssSubscript;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItem;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.function.builtins.clinic.LongIndexConverterNode;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMMap})
public final class MMapBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = MMapBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MMapBuiltinsFactory.getFactories();
    }

    private static byte[] readBytes(VirtualFrame frame, Node inliningTarget, PMMap self, PosixSupportLibrary posixLib, Object posixSupport, long pos, int len, PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
        try {
            assert (len > 0);
            assert (pos + (long)len <= self.getLength());
            byte[] buffer = new byte[len];
            posixLib.mmapReadBytes(posixSupport, self.getPosixSupportHandle(), pos, buffer, buffer.length);
            return buffer;
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
        }
    }

    static class ReleaseCallback
    implements AsyncHandler.AsyncAction {
        private final PMMap.MMapRef ref;

        ReleaseCallback(PMMap.MMapRef ref) {
            this.ref = ref;
        }

        @Override
        public void execute(PythonContext context) {
            if (this.ref.isReleased()) {
                return;
            }
            PythonLanguage language = context.getLanguage();
            RootCallTarget callTarget = language.createCachedCallTarget(ReleaserRootNode::new, ReleaserRootNode.class);
            callTarget.call(new Object[]{this.ref});
        }

        private static class ReleaserRootNode
        extends RootNode {
            @Node.Child
            private PosixSupportLibrary posixSupportLibrary = (PosixSupportLibrary)PosixSupportLibrary.getFactory().createDispatched(1);

            ReleaserRootNode(TruffleLanguage<?> language) {
                super(language);
            }

            public Object execute(VirtualFrame frame) {
                PMMap.MMapRef ref = (PMMap.MMapRef)frame.getArguments()[0];
                ref.close(this.posixSupportLibrary, PythonContext.get((Node)this).getPosixSupport());
                return null;
            }
        }
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1, parameterNames={"$self", "offset", "size"})
    @GenerateNodeFactory
    @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.LongIndex, defaultValue="0")
    static abstract class FlushNode
    extends PythonTernaryClinicBuiltinNode {
        FlushNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MMapBuiltinsClinicProviders.FlushNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object flush(VirtualFrame frame, PMMap self, long offset, Object sizeObj, @Bind Node inliningTarget, @Bind PythonContext context, @Cached LongIndexConverterNode sizeConversion, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            long size = sizeObj == PNone.NO_VALUE ? self.getLength() : sizeConversion.executeLong(frame, sizeObj);
            if (size < 0L || offset < 0L || self.getLength() - offset < size) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.FLUSH_VALUES_OUT_OF_RANGE);
            }
            if (self.getAccess() == 1 || self.getAccess() == 3) {
                return PNone.NONE;
            }
            try {
                posixLib.mmapFlush(context.getPosixSupport(), self.getPosixSupportHandle(), offset, self.getLength());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="find", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentClinic(name="sub", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    public static abstract class FindNode
    extends PythonQuaternaryClinicBuiltinNode {
        private static final int BUFFER_SIZE = 1024;

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MMapBuiltinsClinicProviders.FindNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static long find(VirtualFrame frame, PMMap self, Object subBuffer, Object startIn, Object endIn, @Bind Node inliningTarget, @Bind PythonContext context, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="subBuffer") PythonBufferAccessLibrary bufferLib, @Cached LongIndexConverterNode startConverter, @Cached LongIndexConverterNode endConverter, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            try {
                int bufferSize;
                long start = FindNode.normalizeIndex(frame, startConverter, startIn, self.getLength(), self.getPos());
                long end = FindNode.normalizeIndex(frame, endConverter, endIn, self.getLength(), self.getLength());
                byte[] sub = bufferLib.getInternalOrCopiedByteArray(subBuffer);
                int subLen = bufferLib.getBufferLength(subBuffer);
                int buffersIndex = bufferSize = Math.max(1024, subLen);
                byte[] firstBuffer = new byte[bufferSize];
                byte[] secondBuffer = new byte[bufferSize];
                FindNode.readBytes(frame, inliningTarget, self, posixLib, context.getPosixSupport(), start, secondBuffer, constructAndRaiseNode, raiseNode);
                long selfIdx = start;
                while (selfIdx <= end - (long)subLen) {
                    if (buffersIndex + subLen > bufferSize * 2) {
                        byte[] tmp = firstBuffer;
                        firstBuffer = secondBuffer;
                        secondBuffer = tmp;
                        buffersIndex -= bufferSize;
                        long readIndex = selfIdx + (long)subLen - 1L;
                        FindNode.readBytes(frame, inliningTarget, self, posixLib, context.getPosixSupport(), readIndex, secondBuffer, constructAndRaiseNode, raiseNode);
                    }
                    boolean found = true;
                    for (int subIdx = 0; subIdx < subLen; ++subIdx) {
                        int currentBuffersIdx = buffersIndex + subIdx;
                        byte value = currentBuffersIdx >= bufferSize ? secondBuffer[currentBuffersIdx % bufferSize] : firstBuffer[currentBuffersIdx];
                        if (sub[subIdx] == value) continue;
                        found = false;
                        break;
                    }
                    if (found) {
                        long l = selfIdx;
                        return l;
                    }
                    ++selfIdx;
                    ++buffersIndex;
                }
                long l = -1L;
                return l;
            }
            finally {
                bufferLib.release(subBuffer, frame, indirectCallData);
            }
        }

        private static void readBytes(VirtualFrame frame, Node inliningTarget, PMMap self, PosixSupportLibrary posixLib, PosixSupport posixSupport, long index, byte[] buffer, PConstructAndRaiseNode.Lazy constructAndRaiseNode, PRaiseNode raiseNode) {
            try {
                long remaining = self.getLength() - index;
                int toReadLen = remaining > (long)buffer.length ? buffer.length : (int)remaining;
                int nread = posixLib.mmapReadBytes(posixSupport, self.getPosixSupportHandle(), index, buffer, toReadLen);
                if (toReadLen != nread) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.MMAP_CHANGED_LENGTH);
                }
            }
            catch (PosixSupportLibrary.PosixException ex) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, ex);
            }
        }

        private static long normalizeIndex(VirtualFrame frame, LongIndexConverterNode converter, Object idxObj, long len, long defaultValue) {
            if (PGuards.isNoValue(idxObj)) {
                return defaultValue;
            }
            long idx = converter.executeLong(frame, idxObj);
            if (idx < 0L) {
                idx += len;
            }
            if (idx < 0L) {
                idx = 0L;
            } else if (idx > len) {
                idx = len;
            }
            return idx;
        }
    }

    @Builtin(name="seek", parameterNames={"$self", "dist", "how"})
    @ArgumentsClinic(value={@ArgumentClinic(name="dist", conversion=ArgumentClinic.ClinicConversion.LongIndex), @ArgumentClinic(name="how", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class SeekNode
    extends PythonTernaryClinicBuiltinNode {
        SeekNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MMapBuiltinsClinicProviders.SeekNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object seek(PMMap self, long dist, int how, @Bind Node inliningTarget, @Cached InlinedBranchProfile errorProfile, @Cached PRaiseNode raiseNode) {
            long where = switch (how) {
                case 0 -> dist;
                case 1 -> self.getPos() + dist;
                case 2 -> self.getLength() + dist;
                default -> {
                    errorProfile.enter(inliningTarget);
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.UNKNOWN_S_TYPE, "seek");
                }
            };
            if (where > self.getLength() || where < 0L) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.SEEK_OUT_OF_RANGE);
            }
            self.setPos(where);
            return PNone.NONE;
        }
    }

    @Builtin(name="write", parameterNames={"$self", "data"})
    @ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends PythonBinaryClinicBuiltinNode {
        WriteNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MMapBuiltinsClinicProviders.WriteNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(limit="3")
        static int doIt(VirtualFrame frame, PMMap self, Object dataBuffer, @Bind Node inliningTarget, @Bind PythonContext context, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="dataBuffer") PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            try {
                if (!self.isWriteable()) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MMAP_CANNOT_MODIFY_READONLY_MEMORY);
                }
                byte[] dataBytes = bufferLib.getInternalOrCopiedByteArray(dataBuffer);
                int dataLen = bufferLib.getBufferLength(dataBuffer);
                if (self.getPos() > self.getLength() || self.getLength() - self.getPos() < (long)dataLen) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.DATA_OUT_OF_RANGE);
                }
                posixLib.mmapWriteBytes(context.getPosixSupport(), self.getPosixSupportHandle(), self.getPos(), dataBytes, dataLen);
                self.setPos(self.getPos() + (long)dataLen);
                int n = dataLen;
                return n;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                bufferLib.release(dataBuffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends PythonUnaryBuiltinNode {
        private static final int BUFFER_SIZE = 1024;

        ReadlineNode() {
        }

        @Specialization
        static Object readline(VirtualFrame frame, PMMap self, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached SequenceStorageNodes.AppendNode appendNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            ByteSequenceStorage res = new ByteSequenceStorage(16);
            byte[] buffer = new byte[1024];
            block2: while (self.getPos() < self.getLength()) {
                int nread;
                try {
                    nread = posixLib.mmapReadBytes(context.getPosixSupport(), self.getPosixSupportHandle(), self.getPos(), buffer, (int)Math.min(self.getRemaining(), (long)buffer.length));
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                for (int i = 0; i < nread; ++i) {
                    byte b = buffer[i];
                    appendNode.execute(inliningTarget, res, b, BytesNodes.BytesLikeNoGeneralizationNode.SUPPLIER);
                    if (b != 10) continue;
                    self.setPos(self.getPos() + (long)i + 1L);
                    break block2;
                }
                self.setPos(self.getPos() + (long)nread);
            }
            return PFactory.createBytes(context.getLanguage(inliningTarget), res);
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends PythonBuiltinNode {
        ReadNode() {
        }

        @Specialization
        static PBytes read(VirtualFrame frame, PMMap self, Object n, @Bind Node inliningTarget, @Bind PythonContext context, @Cached InlinedConditionProfile noneProfile, @Cached InlinedConditionProfile emptyProfile, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached InlinedConditionProfile negativeProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            long nread;
            if (noneProfile.profile(inliningTarget, PGuards.isPNone(n))) {
                nread = self.getRemaining();
            } else {
                if (!indexCheckNode.execute(inliningTarget, n)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARG_SHOULD_BE_INT_OR_NONE, n);
                }
                nread = asSizeNode.executeExact((Frame)frame, inliningTarget, n);
                if (negativeProfile.profile(inliningTarget, nread < 0L)) {
                    nread = self.getRemaining();
                } else if (nread > self.getRemaining()) {
                    nread = self.getRemaining();
                }
            }
            if (emptyProfile.profile(inliningTarget, nread == 0L)) {
                return PFactory.createEmptyBytes(context.getLanguage(inliningTarget));
            }
            try {
                byte[] buffer = MMapBuiltins.readBytes(frame, inliningTarget, self, posixLib, context.getPosixSupport(), self.getPos(), PythonUtils.toIntExact(nread), constructAndRaiseNode);
                self.setPos(self.getPos() + (long)buffer.length);
                return PFactory.createBytes(context.getLanguage(inliningTarget), buffer);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.TOO_MANY_REMAINING_BYTES_TO_BE_STORED);
            }
        }
    }

    @Builtin(name="read_byte", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadByteNode
    extends PythonUnaryBuiltinNode {
        ReadByteNode() {
        }

        @Specialization
        static int readByte(VirtualFrame frame, PMMap self, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixSupportLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            if (self.getPos() >= self.getLength()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.READ_BYTE_OUT_OF_RANGE);
            }
            try {
                byte res = posixSupportLib.mmapReadByte(context.getPosixSupport(), self.getPosixSupportHandle(), self.getPos());
                self.setPos(self.getPos() + 1L);
                return res & 0xFF;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="tell", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TellNode
    extends PythonBuiltinNode {
        TellNode() {
        }

        @Specialization
        static long readline(PMMap self) {
            return self.getPos();
        }
    }

    @Builtin(name="resize", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ResizeNode
    extends PythonBuiltinNode {
        ResizeNode() {
        }

        @Specialization
        static long resize(PMMap self, Object n, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.RESIZING_NOT_AVAILABLE);
        }
    }

    @Builtin(name="size", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SizeNode
    extends PythonBuiltinNode {
        SizeNode() {
        }

        @Specialization
        static long size(PMMap self) {
            return self.getLength();
        }
    }

    @Builtin(name="closed", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ClosedNode
    extends PythonUnaryBuiltinNode {
        ClosedNode() {
        }

        @Specialization
        static boolean close(PMMap self) {
            return self.isClosed();
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization
        static PNone close(PMMap self, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixSupportLib) {
            self.close(posixSupportLib, context.getPosixSupport());
            return PNone.NONE;
        }
    }

    @Builtin(name="__exit__", minNumOfPositionalArgs=4)
    @GenerateNodeFactory
    static abstract class ExitNode
    extends PythonBuiltinNode {
        protected static final TruffleString T_CLOSE = PythonUtils.tsLiteral("close");

        ExitNode() {
        }

        @Specialization
        static Object size(VirtualFrame frame, PMMap self, Object typ, Object val, Object tb, @Cached(value="create(T_CLOSE)") LookupAndCallUnaryNode callCloseNode) {
            return callCloseNode.executeObject(frame, self);
        }
    }

    @Builtin(name="__enter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class EnterNode
    extends PythonUnaryBuiltinNode {
        EnterNode() {
        }

        @Specialization
        static Object size(PMMap self) {
            return self;
        }
    }

    @Slot.Slots(value={@Slot(value=Slot.SlotKind.sq_length), @Slot(value=Slot.SlotKind.mp_length)})
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        static int len(PMMap self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            return PyNumberAsSizeNode.doLongExact(inliningTarget, self.getLength(), PythonBuiltinClassType.OverflowError, raiseNode);
        }
    }

    @Slot(value=Slot.SlotKind.mp_ass_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class SetSubscriptNode
    extends TpSlotMpAssSubscript.MpAssSubscriptBuiltinNode {
        @Specialization(guards={"!isPSlice(idxObj)"})
        static void doSingle(VirtualFrame frame, PMMap self, Object idxObj, Object valueObj, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixSupportLib, @Cached PyIndexCheckNode checkNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (self.isClosed()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MMAP_CLOSED_OR_INVALID);
            }
            if (self.isReadonly()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MMAP_CANNOT_MODIFY_READONLY_MEMORY);
            }
            if (!checkNode.execute(inliningTarget, idxObj)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MMAP_INDICES_MUST_BE_INTEGER);
            }
            long idx = asSizeNode.executeExact((Frame)frame, inliningTarget, idxObj, PythonBuiltinClassType.IndexError);
            long len = self.getLength();
            long l = idx = idx < 0L ? idx + len : idx;
            if (idx < 0L || idx >= len) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.MMAP_INDEX_OUT_OF_RANGE);
            }
            if (valueObj == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MMAP_OBJECT_DOESNT_SUPPORT_ITEM_DELETION);
            }
            if (!checkNode.execute(inliningTarget, valueObj)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MMAP_ITEM_VALUE_MUST_BE_AN_INT);
            }
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, valueObj, PythonBuiltinClassType.TypeError);
            if (value < 0 || value > 255) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MMAP_ITEM_VALUE_MUST_BE_IN_RANGE);
            }
            try {
                posixSupportLib.mmapWriteByte(context.getPosixSupport(), self.getPosixSupportHandle(), idx, (byte)value);
            }
            catch (PosixSupportLibrary.PosixException ex) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static void doSlice(VirtualFrame frame, PMMap self, PSlice slice, Object valueObj, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixSupportLib, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached SliceNodes.SliceUnpack sliceUnpack, @Cached SliceNodes.AdjustIndices adjustIndices, @Cached InlinedConditionProfile step1Profile, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            block14: {
                int len;
                if (self.isClosed()) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MMAP_CLOSED_OR_INVALID);
                }
                if (self.isReadonly()) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MMAP_CANNOT_MODIFY_READONLY_MEMORY);
                }
                try {
                    len = PInt.intValueExact(self.getLength());
                }
                catch (OverflowException e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
                }
                PSlice.SliceInfo info = adjustIndices.execute(inliningTarget, len, sliceUnpack.execute(inliningTarget, slice));
                if (valueObj == PNone.NO_VALUE) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MMAP_OBJECT_DOESNT_SUPPORT_SLICE_DELETION);
                }
                Object buffer = acquireLib.acquireReadonly(valueObj);
                try {
                    int bufferLen = bufferLib.getBufferLength(buffer);
                    if (info.sliceLength != bufferLen) {
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.MMAP_SLICE_ASSIGNMENT_IS_WRONG_SIZE);
                    }
                    if (info.sliceLength <= 0) break block14;
                    try {
                        if (step1Profile.profile(inliningTarget, info.step == 1)) {
                            posixSupportLib.mmapWriteBytes(context.getPosixSupport(), self.getPosixSupportHandle(), info.start, bufferLib.getInternalOrCopiedByteArray(buffer), bufferLen);
                        } else {
                            int cur = info.start;
                            for (int i = 0; i < info.sliceLength; ++i) {
                                posixSupportLib.mmapWriteByte(context.getPosixSupport(), self.getPosixSupportHandle(), cur, bufferLib.readByte(buffer, i));
                                cur += info.step;
                            }
                        }
                    }
                    catch (PosixSupportLibrary.PosixException ex) {
                        throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, ex);
                    }
                }
                finally {
                    bufferLib.release(buffer);
                }
            }
        }
    }

    @Slot(value=Slot.SlotKind.sq_ass_item, isComplex=true)
    @GenerateNodeFactory
    public static abstract class SetItemNode
    extends TpSlotSqAssItem.SqAssItemBuiltinNode {
        @Specialization
        static void doSingle(VirtualFrame frame, PMMap self, int index, Object val, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixSupportLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached PyBytesCheckNode checkNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            long idx;
            if (self.isClosed()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MMAP_CLOSED_OR_INVALID);
            }
            long len = self.getLength();
            long l = idx = index < 0 ? (long)index + len : (long)index;
            if (idx < 0L || idx >= len) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.MMAP_INDEX_OUT_OF_RANGE);
            }
            if (val == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MMAP_OBJECT_DOESNT_SUPPORT_ITEM_DELETION);
            }
            if (!checkNode.execute(inliningTarget, val) || bufferLib.getBufferLength(val) != 1) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.MMAP_ASSIGNMENT_MUST_BE_LENGTH_1_BYTES);
            }
            if (self.isReadonly()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MMAP_CANNOT_MODIFY_READONLY_MEMORY);
            }
            byte b = bufferLib.readByte(val, 0);
            try {
                posixSupportLib.mmapWriteByte(context.getPosixSupport(), self.getPosixSupportHandle(), idx, b);
            }
            catch (PosixSupportLibrary.PosixException ex) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, ex);
            }
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        @Specialization(guards={"!isPSlice(idxObj)"})
        static int doSingle(VirtualFrame frame, PMMap self, Object idxObj, @Bind Node inliningTarget, @Bind PythonContext context, @Cached.Exclusive @Cached InlinedConditionProfile negativeIndexProfile, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixSupportLib, @Cached PyLongAsLongNode asLongNode, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            long i = asLongNode.execute((Frame)frame, inliningTarget, idxObj);
            long len = self.getLength();
            long idx = negativeIndexProfile.profile(inliningTarget, i < 0L) ? i + len : i;
            IndexNodes.checkBounds(inliningTarget, raiseNode, ErrorMessages.MMAP_INDEX_OUT_OF_RANGE, idx, len);
            try {
                return posixSupportLib.mmapReadByte(context.getPosixSupport(), self.getPosixSupportHandle(), idx) & 0xFF;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        @Specialization
        static Object doSlice(VirtualFrame frame, PMMap self, PSlice idx, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixSupportLib, @Cached.Exclusive @Cached InlinedConditionProfile emptyProfile, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached SliceNodes.ComputeIndices compute, @Cached RangeNodes.LenOfRangeNode sliceLenNode, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            try {
                PSlice.SliceInfo info = compute.execute((Frame)frame, sliceCast.execute(inliningTarget, idx), PInt.intValueExact(self.getLength()));
                int len = sliceLenNode.len(inliningTarget, info);
                if (emptyProfile.profile(inliningTarget, len == 0)) {
                    return PFactory.createEmptyBytes(context.getLanguage(inliningTarget));
                }
                byte[] result = MMapBuiltins.readBytes(frame, inliningTarget, self, posixSupportLib, context.getPosixSupport(), info.start, len, constructAndRaiseNode);
                return PFactory.createBytes(context.getLanguage(inliningTarget), result);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, e);
            }
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    public static abstract class MMapSqItemNode
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        @Specialization
        static PBytes doInt(VirtualFrame frame, PMMap self, int index, @Bind Node inliningTarget, @Bind PythonContext context, @Cached PRaiseNode raiseNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixSupportLib) {
            long len = self.getLength();
            IndexNodes.checkBounds(inliningTarget, raiseNode, ErrorMessages.MMAP_INDEX_OUT_OF_RANGE, index, len);
            try {
                byte b = posixSupportLib.mmapReadByte(context.getPosixSupport(), self.getPosixSupportHandle(), index);
                return PFactory.createBytes(context.getLanguage(inliningTarget), new byte[]{b});
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="mmap", minNumOfPositionalArgs=3, parameterNames={"cls", "fd", "length", "flags", "prot", "access", "offset"})
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="length", conversion=ArgumentClinic.ClinicConversion.LongIndex), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="FLAGS_DEFAULT"), @ArgumentClinic(name="prot", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="PROT_DEFAULT"), @ArgumentClinic(name="access", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ACCESS_ARG_DEFAULT"), @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Long, defaultValue="0")})
    public static abstract class MMapNode
    extends PythonClinicBuiltinNode {
        protected static final int ACCESS_ARG_DEFAULT = 0;
        protected static final int FLAGS_DEFAULT = PosixConstants.MAP_SHARED.value;
        protected static final int PROT_DEFAULT = PosixConstants.PROT_WRITE.value | PosixConstants.PROT_READ.value;
        private static final int ANONYMOUS_FD = -1;

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MMapBuiltinsClinicProviders.MMapNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!isIllegal(fd)"})
        static PMMap doFile(VirtualFrame frame, Object clazz, int fd, long lengthIn, int flagsIn, int protIn, int accessIn, long offset, @Bind Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixSupport, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            Object mmapHandle;
            int dupFd;
            if (lengthIn < 0L) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.MEM_MAPPED_LENGTH_MUST_BE_POSITIVE);
            }
            if (offset < 0L) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.MEM_MAPPED_OFFSET_MUST_BE_POSITIVE);
            }
            int flags = flagsIn;
            int prot = protIn;
            int access = accessIn;
            switch (access) {
                case 1: {
                    flags = PosixConstants.MAP_SHARED.value;
                    prot = PosixConstants.PROT_READ.value;
                    break;
                }
                case 2: {
                    flags = PosixConstants.MAP_SHARED.value;
                    prot = PosixConstants.PROT_READ.value | PosixConstants.PROT_WRITE.value;
                    break;
                }
                case 3: {
                    flags = PosixConstants.MAP_PRIVATE.value;
                    prot = PosixConstants.PROT_READ.value | PosixConstants.PROT_WRITE.value;
                    break;
                }
                case 0: {
                    if ((prot & PosixConstants.PROT_READ.value) != 0 && (prot & PosixConstants.PROT_WRITE.value) != 0) break;
                    if ((prot & PosixConstants.PROT_WRITE.value) != 0) {
                        access = 2;
                        break;
                    }
                    access = 1;
                    break;
                }
                default: {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MEM_MAPPED_OFFSET_INVALID_ACCESS);
                }
            }
            auditNode.audit(inliningTarget, "mmap.__new__", fd, lengthIn, access, offset);
            long length = lengthIn;
            PosixSupport posixSupport1 = PosixSupport.get(inliningTarget);
            if (fd != -1) {
                long[] fstatResult = null;
                try {
                    fstatResult = posixSupport.fstat(posixSupport1, fd);
                }
                catch (PosixSupportLibrary.PosixException posixException) {
                    // empty catch block
                }
                if (fstatResult != null && length == 0L) {
                    if (fstatResult[6] == 0L) {
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.CANNOT_MMAP_AN_EMPTY_FILE);
                    }
                    if (offset >= fstatResult[6]) {
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MMAP_S_IS_GREATER_THAN_FILE_SIZE, "offset");
                    }
                    length = fstatResult[6] - offset;
                } else if (fstatResult != null && (offset > fstatResult[6] || fstatResult[6] - offset < length)) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MMAP_S_IS_GREATER_THAN_FILE_SIZE, "length");
                }
            }
            if (fd == -1) {
                dupFd = -1;
                flags |= PosixConstants.MAP_ANONYMOUS.value;
            } else {
                try {
                    dupFd = posixSupport.dup(posixSupport1, fd);
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            try {
                mmapHandle = posixSupport.mmap(posixSupport1, length, prot, flags, dupFd, offset);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            PythonContext context = PythonContext.get(inliningTarget);
            return PFactory.createMMap(context.getLanguage(inliningTarget), context, clazz, getInstanceShape.execute(clazz), mmapHandle, dupFd, length, access);
        }

        @Specialization(guards={"isIllegal(fd)"})
        static PMMap doIllegal(Object clazz, int fd, long lengthIn, int flagsIn, int protIn, int accessIn, long offset, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.OSError);
        }

        protected static boolean isIllegal(int fd) {
            return fd < -1;
        }
    }
}

